VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{DFEB0DA3-D648-11D4-9C5F-EA48B7E9393D}#1.0#0"; "TVC.OCX"
Begin VB.Form frmAppC 
   Caption         =   "Test Writing and Reading Binary/Ascii Waveform Files"
   ClientHeight    =   4425
   ClientLeft      =   13305
   ClientTop       =   -3270
   ClientWidth     =   7140
   DrawMode        =   14  'Copy Pen
   LinkTopic       =   "Form1"
   ScaleHeight     =   4425
   ScaleWidth      =   7140
   Begin VB.CommandButton cmdWriteBinary 
      Caption         =   "Write Binary"
      Height          =   375
      Left            =   2880
      TabIndex        =   12
      Top             =   2400
      Width           =   1335
   End
   Begin VB.Frame fraRead 
      Caption         =   "Read Data"
      Height          =   3255
      Left            =   5160
      TabIndex        =   5
      Top             =   120
      Width           =   1935
      Begin VB.OptionButton optWriteBtoA 
         Caption         =   "Write Binary to ASCII File"
         Height          =   495
         Left            =   120
         TabIndex        =   9
         Top             =   2280
         Width           =   1695
      End
      Begin VB.OptionButton optListBox 
         Caption         =   "Display in ListBox"
         Height          =   375
         Left            =   120
         TabIndex        =   8
         Top             =   1560
         Value           =   -1  'True
         Width           =   1695
      End
      Begin VB.CommandButton cmdReadBinary 
         Caption         =   "Read Binary"
         Height          =   375
         Left            =   120
         TabIndex        =   7
         Top             =   840
         Width           =   1455
      End
      Begin VB.CommandButton cmdReadAscii 
         Caption         =   "Read Ascii"
         Height          =   375
         Left            =   120
         TabIndex        =   6
         Top             =   360
         Width           =   1455
      End
   End
   Begin VB.Frame fraWrite 
      Caption         =   "Write ASCII  Data"
      Height          =   1935
      Left            =   2640
      TabIndex        =   3
      Top             =   120
      Width           =   2415
      Begin VB.OptionButton optReadToFile 
         Caption         =   "Use ReadToFile method"
         Height          =   375
         Left            =   120
         TabIndex        =   11
         Top             =   840
         Width           =   2175
      End
      Begin VB.OptionButton optReadList 
         Caption         =   "Use ReadList method"
         Height          =   495
         Left            =   120
         TabIndex        =   10
         Top             =   240
         Value           =   -1  'True
         Width           =   2175
      End
      Begin VB.CommandButton cmdWriteAscii 
         Caption         =   "Write Ascii"
         Height          =   375
         Left            =   600
         TabIndex        =   4
         Top             =   1320
         Width           =   1335
      End
   End
   Begin TVCLib.Tvc Tvc1 
      Left            =   4800
      Top             =   3840
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      VisaDescriptor  =   "GPIB8::1::INSTR"
   End
   Begin MSComDlg.CommonDialog dlgTVC 
      Left            =   5400
      Top             =   3840
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "Clear"
      Height          =   375
      Left            =   2880
      TabIndex        =   1
      Top             =   3000
      Width           =   1335
   End
   Begin VB.ListBox lstD 
      Height          =   3570
      Left            =   120
      MultiSelect     =   2  'Extended
      TabIndex        =   0
      Top             =   120
      Width           =   2295
   End
   Begin VB.Label lblStatus 
      BorderStyle     =   1  'Fixed Single
      ForeColor       =   &H00FF0000&
      Height          =   495
      Left            =   120
      TabIndex        =   2
      Top             =   3840
      Width           =   4455
   End
End
Attribute VB_Name = "frmAppC"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim sFileName As String
Dim sAsciiFile As String
Dim bArr() As Byte
Dim tracker As Long
Dim CancelFlag As Boolean
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
Private Declare Function GetTickCount Lib "kernel32" () As Long

Private Sub cmdClear_Click()
  lstD.Clear
  lblStatus.Caption = ""
End Sub
Public Function RemoveLF(s1 As String) As String
    If Right(s1, 1) = vbLf Then
        RemoveLF = Left(s1, Len(s1) - 1)
    Else
       RemoveLF = s1
    End If
End Function

Private Function GetAsciiData()
    Dim sRet As String
    Dim arrHoldHeader() As String, arrHoldData() As String
    Dim arrRet()
    Dim i As Long
    Dim nLFPos As Long
    Dim sHeader As String, sData As String
    Dim sLength As String, sTrigPos As String, sXINCR As String
    Dim nLength As Long, nTrigPos As Long
    Dim rXINCR As Double, t As Double, rHoldV As Double
    Dim yoffset As Double, ymult As Double, yzero As Double
    Dim msg1 As String, msg2 As String
    Dim sHoldM As String
    
    On Error GoTo GetAsciiDataErr
    msg1 = "Error in application file format."
    
    CancelFlag = False
    sRet = HandleOpenDialog("A")
    If CancelFlag Then Exit Function
    
    
    nLFPos = InStr(sRet, vbLf)
    If nLFPos <> 0 Then
       ' get the header and data
       sHeader = Left(sRet, nLFPos - 1)
       sData = Right(sRet, Len(sRet) - nLFPos)
       ' place header and data into arrays
         arrHoldHeader = Split(sHeader, ";")
         arrHoldData = Split(sData, ",")
       If Left(sAsciiFile, 2) = "AF" Then
            For i = LBound(arrHoldHeader) To UBound(arrHoldHeader)
                sHoldM = arrHoldHeader(i)
                If Not sHoldM = "" Then
                 Select Case i
                     Case 0
                          nLength = CLng(arrHoldHeader(i))
                     Case 1
                          nTrigPos = CLng(arrHoldHeader(i))
                     Case 2
                          rXINCR = CDbl(arrHoldHeader(i))
                     Case 3
                          yoffset = CDbl(arrHoldHeader(i))
                     Case 4
                          ymult = CDbl(arrHoldHeader(i))
                     Case 5
                          yzero = CDbl(arrHoldHeader(i))
                 End Select
               End If
            Next
            ' dimension a two dimensional array and return
            ReDim arrRet(0 To nLength - 1, 1 To 2)
            For i = LBound(arrHoldData) To UBound(arrHoldData)
                t = (i - nTrigPos) * rXINCR
                arrRet(i, 1) = Format(t, "#.############")
                'calculate y value
                rHoldV = yzero + ((arrHoldData(i) - yoffset) * ymult)
                arrRet(i, 2) = Format(CDbl(rHoldV), "#.############")
            Next
            GetAsciiData = arrRet
            Exit Function
            
       Else
           ' get the header info
            sLength = arrHoldHeader(0)
            If IsNumeric(sLength) Then
                nLength = CLng(sLength)
            End If
            sTrigPos = arrHoldHeader(1)
            
            If IsNumeric(sTrigPos) Then
                nTrigPos = CLng(sTrigPos)
            End If
              
            sXINCR = arrHoldHeader(2)
            If IsNumeric(sXINCR) Then
               rXINCR = CDbl(sXINCR)
            End If
              
            ' dimension a two dimensional array and return
            ReDim arrRet(0 To nLength - 1, 1 To 2)
            For i = LBound(arrHoldData) To UBound(arrHoldData)
                t = (i - nTrigPos) * rXINCR
                arrRet(i, 1) = Format(t, "#.############")
                arrRet(i, 2) = Format(CDbl(arrHoldData(i)), "#.############")
            Next
            GetAsciiData = arrRet
            Exit Function
    
       End If
    Else
       MsgBox msg1, vbOKOnly
       GetAsciiData = ""
       Exit Function
    End If
    
    
    
  Exit Function
GetAsciiDataErr:
 MsgBox "Error " & Err.Number & ": " & Err.Description
 GetAsciiData = ""
End Function

Private Function GetBinaryData()
  '**************************************************************************************************
  ' This routine parses the binary file (returned as a byte array), calculates x and y axis values
  ' It returns a two-dimensional array of x,y pairs
    
  ' the file format it parses is:
  '[record length];[trigger position];[x increment];[yoffset];[ymult];[yzero]
  'carriage return character
  'values in 2-byte increments
  '***************************************************************************************************
   Dim arr() As Byte
   Dim hold1() As Byte, hold2() As Byte
   Dim nCRpos As Long
   Dim i As Long, nStart As Long
   Dim arrPass() As Double
   Dim sMData As String, arrM() As String, sHoldM As String, nHoldV As Long
   Dim reclength As Long, trigpos As Long, xinc As Double, yoffset As Double, ymult As Double, yzero As Double
   Dim nTracki As Long
   Dim sRecbytes As String, nRecBytes As Integer
   Dim sBytes As String, nBytes As Long
   Dim msg As String, temp As String
   
   
   
  
   On Error GoTo GetBinaryDataErr
   
   CancelFlag = False
   arr = HandleOpenDialog("B")
   If CancelFlag = True Then Exit Function
   
   ' locate the linefeed character separating the header from the data
   For i = LBound(arr) To UBound(arr)
      If arr(i) = 13 Then
        nCRpos = i
        Exit For
      End If
   Next
   If nCRpos = 0 Then
      MsgBox "Error in file format"
      Exit Function
   End If
   
   'place the semicolon-separated header information in a byte array
   hold1 = LeftB(arr, nCRpos - 1)
   'use the Split function to place the byte array into a string array
   sMData = StrConv(hold1, vbUnicode)
   ' assign array elements to variables
   arrM = Split(sMData, ";")
   For i = LBound(arrM) To UBound(arrM)
      sHoldM = arrM(i)
      If Not sHoldM = "" Then
            Select Case i
                Case 0
                     reclength = CLng(arrM(i))
                Case 1
                     trigpos = CLng(arrM(i))
                Case 2
                     xinc = CDbl(arrM(i))
                Case 3
                     yoffset = CDbl(arrM(i))
                Case 4
                     ymult = CDbl(arrM(i))
                Case 5
                     yzero = CDbl(arrM(i))
            End Select
      End If
   Next
   
   ' place the binary yvalue data into a byte array
   hold2 = RightB(arr, UBound(arr) - nCRpos)
   ' get number of bytes in waveform prefix(#[numx]xxx..)
   sRecbytes = MidB(hold2, 2, 1)
   ' convert to string
   temp = StrConv(sRecbytes, vbUnicode)
   ' convert to integer
   nRecBytes = CInt(temp)
   ' locate start of data; used as starting point in for loop below
   nStart = 3 + nRecBytes
   ' retrieve number of bytes
   sBytes = MidB(hold2, 3, nRecBytes)
   ' convert to string
   temp = StrConv(sBytes, vbUnicode)
   nBytes = CLng(temp)  ' hold reported length in header
  
   ' dimension the array
   ReDim arrPass(1 To 2, 1 To nBytes) As Double
   nTracki = 1
 
   For i = nStart To UBound(hold2)
      If nTracki > nBytes Then Exit For
      If hold2(i) = 10 Then Exit For
      
      If hold2(i) > 127 Then
         nHoldV = hold2(i) - 256
      Else
         nHoldV = hold2(i)
      End If
      
      arrPass(1, nTracki) = ((nTracki - 1) - trigpos) * xinc
      arrPass(2, nTracki) = yzero + ((nHoldV - yoffset) * ymult)
     
     nTracki = nTracki + 1
   Next
   
   GetBinaryData = arrPass
   
   
Exit Function
   
 

GetBinaryDataErr:
   msg = "Error " & Err.Number & ": " & Err.Description
   MsgBox msg

End Function

Private Sub cmdReadAscii_Click()
   Dim sRet
   Dim i As Long
   Dim msg1 As String
   
   On Error GoTo cmdReadAsciiErr
   
   
   If optListBox.Value = True Then
      lstD.Clear
      sRet = GetAsciiData
      
      If CancelFlag Then Exit Sub
      If Not IsArray(sRet) Then Exit Sub
      
      For i = LBound(sRet, 1) To UBound(sRet, 1)
          lstD.AddItem sRet(i, 1) & "," & sRet(i, 2)
      Next
   
   Else
      msg1 = "This option not available for reading ASCII files"
      MsgBox msg1, vbOKOnly
      Exit Sub
   End If
   
   
   
   Exit Sub
cmdReadAsciiErr:
  MsgBox "Error " & Err.Number & ": " & Err.Description
   
End Sub

Private Sub cmdReadBinary_Click()
    
   Dim arr
   Dim i As Long
   Dim nLength As Long
   Dim fnum As Integer
   Dim shold As String
   On Error GoTo cmdReadBinaryErr
   
   arr = GetBinaryData
   If CancelFlag Then Exit Sub
   If Not IsArray(arr) Then
       MsgBox "Error in reading data."
       Exit Sub
   End If
   
   nLength = UBound(arr, 2)
        
      If optListBox.Value = True Then
           If nLength > 50000 Then
               MsgBox "Record length limited to 50000 or less for list box display"
               Exit Sub
           End If
          ' display array in list box
          For i = LBound(arr, 2) To nLength
              lstD.AddItem arr(1, i) & "," & arr(2, i)
          Next
      
      Else   ' we are writing the binary data to an ASCII file
         Call HandleSaveDialog("BtoA")
         fnum = FreeFile
         Open sFileName For Append As #fnum
         
         For i = LBound(arr, 2) To nLength
             shold = arr(1, i) & "," & arr(2, i)
             Print #fnum, shold
         Next
         Close #fnum
      End If
      Exit Sub
cmdReadBinaryErr:
  MsgBox "Error " & Err.Number & ": " & Err.Description
  Close
End Sub



Private Sub cmdWriteAscii_Click()
  Dim shold As String, sXData As String, sWrite As String
   Dim nsize As Long, fnum As Integer
   Dim i As Long
   Dim wfm, mData
   Dim rl As Long, buflength As Long
   Dim lb As Long, ub As Long
   Dim start As Long, finish As Long, diff As Long
   Dim flen  As Long
   Const sep = ","
  
  'This routine writes ASCII data with two different header formats, depending upon the
  'method used to write data to disk; if using ReadList with YModelEnabled only the XAxis
  'information is stored in the header. This file format is:
  
  '[record length];[trigger position];[x increment]
  'linefeed character
  'calculated value, calculated value, ...nRecordLength
  
   'If using the ReadToFile method, both YAxis and XAxis information must be stored in the
   ' header file.  This header format is:
   
   ' the file format is:
  '[record length];[trigger position];[x increment];[yoffset];[ymult];[yzero]
  'linefeed character
  'calculated value, calculated value, ...nRecordLength
   
   On Error GoTo cmdWriteASCIIErr
   
   Const HOFF As String = "HEADER OFF;:"
   With Tvc1
      .DeviceClear
      .Lock
      .WriteString "DATA:SOURCE CH1"
      ' set the data encoding
      .WriteString "WFMOUTPRE:ENCDG ASC"
      .WriteString "WFMOUTPRE:BYT_NR 2"
     
     'get the Yaxis properties for floating-point conversion
       .WriteString HOFF & "WFMOUTPRE:YOFF?;YMULT?;YZERO?"
        mData = .ReadList(ASCIIType_BSTR, ";")

        If Not IsArray(mData) Then
           MsgBox "Error in creating array.", vbOKOnly
           Exit Sub
         End If
          
       ' set starting and end points point
       .WriteString "DATA:START 0"
       
       
       ' get recordlength
       .WriteString HOFF & "HORIZONTAL:RECORDLENGTH?"
        rl = CLng(.ReadString)
       ' set data stop
       .WriteString "DATA:STOP " & rl
       
       ' retrieve trigger position and x increment values
       .WriteString "WFMOUTPRE:PT_OFF?;XINCR?"
        ' different header requirements; ReadList calculates Y axis values for you
        ' using ReadToFile method requires that you store YAXIS information and perform
        ' calculations in code when reading the file from disk (see GetAsciiData routine)
        If optReadList.Value = True Then
             sXData = RemoveLF(.ReadString)
             sXData = rl & ";" & sXData & vbLf
             
             CancelFlag = False
             Call HandleSaveDialog("A")
             If CancelFlag Then Exit Sub
        
        ElseIf optReadToFile = True Then
             '[record length];[trigger position];[x increment];[yoffset];[ymult];[yzero]
             sXData = RemoveLF(.ReadString)
             sXData = rl & ";" & sXData & ";" & mData(1) & ";" & mData(2) & ";" & RemoveLF(Str$(mData(3))) & vbLf
        
             CancelFlag = False
             Call HandleSaveDialog("AF")
             If CancelFlag Then Exit Sub
             
        End If
        
          
        .Timeout = 20000
        start = GetTickCount
       
        lblStatus.Caption = "Saving data...."
        DoEvents
        
         fnum = FreeFile
         Open sFileName For Append As #fnum
          ' write the data header line
         Print #fnum, sXData
         
        If optReadList.Value = True Then
            .YModelEnabled = True
            .yoffset = mData(1)
            .ymult = mData(2)
            .yzero = mData(3)
            .WriteString HOFF & "CURVE?"
            wfm = .ReadList(ASCIIType_I2, ",")
            'Allocate an oversized buffer in memory; 12 possible characters w/ 2-byte Unicode
            'characters equals 24 possible bytes per value; we assume that we will have enough
            ' to accommodate the comma separators.
            buflength = rl * 24
            ReDim bArr(buflength)
            tracker = 0
            lb = LBound(wfm)
            ub = UBound(wfm)
            For i = lb To ub
               If i < ub Then
                  shold = wfm(i) & sep
               Else
                   ' remove last comma
                  shold = wfm(i)
               End If
               Call ConcatInBuffer(shold)
            Next
         
             ' assign the array to a string
            sWrite = bArr
             ' find the null character and take everything to the left of it
            sWrite = Left(sWrite, InStr(sWrite, Chr$(0)) - 1)
             ' write it to disk
            Print #fnum, sWrite
             ' display time and filesize calculations
             finish = GetTickCount
             diff = finish - start
             flen = LOF(fnum)
             Close #fnum
             lblStatus.Caption = "Seconds: " & (diff / 1000) & " Reclength: " & _
                                 rl & " FileLength: " & CInt(flen / 1024) & "KB"
             .YModelEnabled = False
        ElseIf optReadToFile = True Then
             'close the file w/ the header information and append to
             'it using ReadToFile method of the TekVISA control
              Close #fnum
             .WriteString HOFF & "CURVE?"
             .FileAppendEnabled = True
             Do
                .ReadToFile sFileName, 1024, flen
             Loop While flen = 1024
             .FileAppendEnabled = False
             finish = GetTickCount
             diff = finish - start
             lblStatus.Caption = "Seconds: " & (diff / 1000) & " Reclength: " & _
                                 rl & " FileLength: " & CInt(FileLen(sFileName) / 1024) & "KB"
        End If
             
      .Unlock
   End With
   
   Exit Sub
cmdWriteASCIIErr:
   Dim msg As String
   Screen.MousePointer = vbDefault
   lblStatus.Caption = ""
   msg = "Error " & Err.Number & ": " & Err.Description
   MsgBox msg
   Close
End Sub

Private Sub cmdWriteBinary_Click()
   
   Dim shold As String, sHeader As String, sXData As String
   Dim i As Long
   Dim mData
   Dim rl As Long, rlOut As Long
   Dim nCRpos As Long
   Dim fnum As Integer
   Dim start As Long, finish As Long, diff As Long
   Dim flen  As Long
   Const HOFF As String = "HEADER OFF;:"
   
  
  ' This routine stores xaxis and yaxis values in the header file.  It is separated from the
  ' data portion by a linefeed character.  The header values are separated by a semicolon
  
  
  ' the file format is:
  '[record length];[trigger position];[x increment];[yoffset];[ymult];[yzero]
  'linefeed character
  'values in 1-byte increments
  
   On Error GoTo cmdTestBinaryErr
   
   With Tvc1
      .DeviceClear
      .Lock
      .WriteString "DATA:SOURCE CH1"
      
      
       ' set the data encoding, byte ordering, binary format, and byte width
       .WriteString "WFMOUTPRE:ENCDG BIN"
       .WriteString "WFMOUTPRE:BYT_OR LSB"
       .WriteString "WFMOUTPRE:BN_FMT RI"
       .WriteString "WFMOUTPRE:BYT_NR 1"
       
       ' set starting point
       .WriteString "DATA:START 1"
       
       ' make sure we get the entire waveform
       .WriteString HOFF & "HORIZONTAL:RECORDLENGTH?"
        shold = .ReadString
        shold = RemoveLF(shold)
        rl = CLng(shold)
       
       .WriteString "DATA:STOP " & rl
       'retrieve the Yaxis properties for floating-point conversion
       .WriteString HOFF & "WFMOUTPRE:YOFF?;YMULT?;YZERO?"
        'add to header string
        sHeader = RemoveLF(.ReadString)
     
       ' retrieve trigger position and x increment values
       .WriteString "WFMOUTPRE:PT_OFF?;XINCR?"
       ' continue building the header string
        sXData = RemoveLF(.ReadString)
        sXData = rl & ";" & sXData
        sHeader = sXData & ";" & sHeader & vbCr
       ' write the header to the file
        CancelFlag = False
        Call HandleSaveDialog("B")
        If CancelFlag Then Exit Sub
        
        fnum = FreeFile
        Open sFileName For Binary As #fnum
        Put #fnum, , sHeader
        Close #fnum
      
     
        .Timeout = 20000
         start = GetTickCount
          
         .WriteString HOFF & "CURVE?"
         lblStatus.Caption = "Saving data...."
         DoEvents
           
         .FileAppendEnabled = True
          Do
            Call .ReadToFile(sFileName, 1024, rlOut)
          Loop While rlOut = 1024
            
         .FileAppendEnabled = False
           
          ' display time and filesize calculations
          finish = GetTickCount
          diff = finish - start
          flen = FileLen(sFileName)
          Close #fnum
          lblStatus.Caption = "Seconds: " & (diff / 1000) & " Reclength: " & _
                              rl & " FileLength: " & CInt(flen / 1024) & "KB"
         
       .Unlock
   End With
   
   Exit Sub
  
  
cmdTestBinaryErr:
    Dim msg As String
   Screen.MousePointer = vbDefault
    lblStatus.Caption = ""
   msg = "Error " & Err.Number & ": " & Err.Description
   MsgBox msg
   Close
End Sub

Private Sub Form_Load()
   Me.Left = Screen.Width / 10
   Me.Top = Screen.Height / 25
End Sub

Public Function HandleOpenDialog(ftype As String)

Dim msg As String
Dim bArr() As Byte
Dim sRet As String
Dim sFName As String
Dim fnum As Integer
Dim nLength As Long
  On Error GoTo HandleOpenDlgErr
  
        With dlgTVC
           .Flags = cdlOFNHideReadOnly + cdlOFNPathMustExist + cdlOFNExplorer
            .DialogTitle = "Retrieving Scope Data"
            .Filter = "Data files(*.dat)|*.dat|All files(*.*)|*.*"
            .FilterIndex = 1
            .ShowOpen
             sFName = .FileName
             sAsciiFile = .FileTitle
            fnum = FreeFile
            nLength = FileLen(sFName)
            ' open and close to create file and erase any prior contents if it exists
            If ftype = "A" Then
               Open sFName For Input As #fnum
            Else
               Open sFName For Binary As #fnum
            End If
            
            If ftype = "B" Then
               ReDim bArr(nLength) As Byte
               Get #fnum, , bArr
               HandleOpenDialog = bArr
            ElseIf ftype = "A" Then
               sRet = Input(nLength, #fnum)
               HandleOpenDialog = sRet
               
            End If
            Close #fnum
       End With
   
   Exit Function
HandleOpenDlgErr:
msg = "Error " & Err.Number & ": " & Err.Description
Select Case Err.Number
   Case mscomdlg.cdlCancel
       sFileName = ""
       CancelFlag = True
       Close
       Err.Clear
       Exit Function
   Case Else
       MsgBox msg, vbOKOnly
       Close
End Select

End Function

Public Sub HandleSaveDialog(ftype As String)
' this routine uses the MS Common dialog control to open a file (timestamp default) for saving
' captured data to disk; called from SRQHandler routines
Dim msg As String
Dim sFileDefault As String
Dim d As Date
Dim fnum As Integer



On Error GoTo HandleSaveDlgErr
' create a default timestamp file name
d = Now
sFileDefault = Format(d, "yy") & Format(d, "mm") & Format(d, "dd") _
                       & "_" & Format(d, "hh") & Format(d, "nn") & Format(d, "ss")
                       
sFileDefault = ftype & sFileDefault
With dlgTVC
    .Flags = cdlOFNHideReadOnly + cdlOFNPathMustExist + cdlOFNExplorer + cdlOFNOverwritePrompt
    .DialogTitle = "Save Scope Data"
    .Filter = "Data files(*.dat)|*.dat|All files(*.*)|*.*"
     sFileDefault = sFileDefault & ".dat"
    .FileName = sFileDefault
    .FilterIndex = 1
    .ShowSave
     sFileName = .FileName
    fnum = FreeFile
    ' open and close to create file and erase any prior contents if it exists
    If ftype = "A" Or ftype = "BtoA" Or ftype = "AF" Then
       Open sFileName For Output As #fnum
    ElseIf ftype = "B" Then
       Open sFileName For Binary As #fnum
    End If
    Close #fnum
    
End With


Exit Sub
HandleSaveDlgErr:
msg = "Error " & Err.Number & ": " & Err.Description
Select Case Err.Number
   Case mscomdlg.cdlCancel
       sFileName = ""
       CancelFlag = True
       Exit Sub
   Case Else
       MsgBox msg, vbOKOnly
End Select


End Sub


Public Sub ConcatInBuffer(ByRef s1 As String)
   ' this routine uses CopyMemory (Alias for RtlMoveMemory) API call to speed up
   ' string concatenation in VB; enormous difference in performance
   Static Len_s1 As Long
   
   ' Get Byte length of passed text.
   Len_s1 = LenB(s1)
   
   If Len_s1 > 0 Then
         ' Copy passed string into preallocated buffer.
      Call CopyMemory(bArr(tracker), ByVal StrPtr(s1), Len_s1)
    
     ' increment byte tracking variable by byte length of passed string
      tracker = tracker + Len_s1
   End If
   
  
End Sub

